/*
========================================================================================================================
 Resource API: "request-limit"

 [GET] "/VeteranAppointmentRequestService/v4/rest
            /direct-scheduling/patient/{assigning-authority}/{patient-id}/request-limit-met"

    Parameters:
        assigning-authority (string) The type of patient id to be used
            example: ICN
        patient-id (string|number) The id of patient written in the format of the assigning-authority
        site-code (string|number) The facilities that the patient is registered at
    Attributes:
        clinical-service (string|number) Types of Care ID
            example: 323 for Primary Care
        institution-code (string|number) The 3 or 5 digit facility name

========================================================================================================================
 Schema: {
   "numberOfRequests" : <number>,
   "requestLimit" : <number>
 }

========================================================================================================================
 Example: {
   "numberOfRequests" : 1,
   "requestLimit" : 5
 }

========================================================================================================================
 */
define([
    'underscore',
    'models/abstract-model',
    'User',
], function(_, Model, user) {
    'use strict';


    return Model.extend({
        resourceName: 'request-limit',

        url: function() {
            var resource = this.getResource();

            return resource.formatHref({
                'assigning-authority': user.get('idType'),
                'patient-id': user.id,
            });
        },

        /**
         * @param {String|Number} institutionCode The 3 or 5 digit facility name
         * @param {String|Number} clinicalService Types of Care ID
         * @param {*} [options] Fetch Options
         * @return {JQueryXHR}
         */
        fetchRequestLimit: function(institutionCode, clinicalService, options) {
            var request = _.extend({}, options);
            request.data = _.extend({}, request.data, {
                'clinical-service': clinicalService,
                'institution-code': institutionCode,
            });

            return this.fetch(request);
        },

        hasRequestsLeft: function() {
            var requestLimit = this.get('requestLimit');
            var numberOfRequests;

            if (this.get('requestLimit') === 0) {
                return true;
            }
            numberOfRequests = this.get('numberOfRequests');
            return numberOfRequests < requestLimit;
        },
    });
});
